package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetProductTaxCategory {
  private ResourceIdentifierInput taxCategory;

  public SetProductTaxCategory() {
  }

  public SetProductTaxCategory(ResourceIdentifierInput taxCategory) {
    this.taxCategory = taxCategory;
  }

  public ResourceIdentifierInput getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(ResourceIdentifierInput taxCategory) {
    this.taxCategory = taxCategory;
  }

  @Override
  public String toString() {
    return "SetProductTaxCategory{taxCategory='" + taxCategory + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductTaxCategory that = (SetProductTaxCategory) o;
    return Objects.equals(taxCategory, that.taxCategory);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxCategory);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput taxCategory;

    public SetProductTaxCategory build() {
      SetProductTaxCategory result = new SetProductTaxCategory();
      result.taxCategory = this.taxCategory;
      return result;
    }

    public Builder taxCategory(ResourceIdentifierInput taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }
  }
}
