package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetProjectSettingsExternalOAuth {
  private ExternalOAuthDraft externalOAuth;

  public SetProjectSettingsExternalOAuth() {
  }

  public SetProjectSettingsExternalOAuth(ExternalOAuthDraft externalOAuth) {
    this.externalOAuth = externalOAuth;
  }

  public ExternalOAuthDraft getExternalOAuth() {
    return externalOAuth;
  }

  public void setExternalOAuth(ExternalOAuthDraft externalOAuth) {
    this.externalOAuth = externalOAuth;
  }

  @Override
  public String toString() {
    return "SetProjectSettingsExternalOAuth{externalOAuth='" + externalOAuth + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProjectSettingsExternalOAuth that = (SetProjectSettingsExternalOAuth) o;
    return Objects.equals(externalOAuth, that.externalOAuth);
  }

  @Override
  public int hashCode() {
    return Objects.hash(externalOAuth);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ExternalOAuthDraft externalOAuth;

    public SetProjectSettingsExternalOAuth build() {
      SetProjectSettingsExternalOAuth result = new SetProjectSettingsExternalOAuth();
      result.externalOAuth = this.externalOAuth;
      return result;
    }

    public Builder externalOAuth(ExternalOAuthDraft externalOAuth) {
      this.externalOAuth = externalOAuth;
      return this;
    }
  }
}
