package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation {
  private ResourceIdentifierInput associateRole;

  public SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation() {
  }

  public SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation(
      ResourceIdentifierInput associateRole) {
    this.associateRole = associateRole;
  }

  public ResourceIdentifierInput getAssociateRole() {
    return associateRole;
  }

  public void setAssociateRole(ResourceIdentifierInput associateRole) {
    this.associateRole = associateRole;
  }

  @Override
  public String toString() {
    return "SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation{associateRole='" + associateRole + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation that = (SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation) o;
    return Objects.equals(associateRole, that.associateRole);
  }

  @Override
  public int hashCode() {
    return Objects.hash(associateRole);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput associateRole;

    public SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation build() {
      SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation result = new SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation();
      result.associateRole = this.associateRole;
      return result;
    }

    public Builder associateRole(ResourceIdentifierInput associateRole) {
      this.associateRole = associateRole;
      return this;
    }
  }
}
