package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetReviewAuthorName {
  private String authorName;

  public SetReviewAuthorName() {
  }

  public SetReviewAuthorName(String authorName) {
    this.authorName = authorName;
  }

  public String getAuthorName() {
    return authorName;
  }

  public void setAuthorName(String authorName) {
    this.authorName = authorName;
  }

  @Override
  public String toString() {
    return "SetReviewAuthorName{authorName='" + authorName + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetReviewAuthorName that = (SetReviewAuthorName) o;
    return Objects.equals(authorName, that.authorName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authorName);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String authorName;

    public SetReviewAuthorName build() {
      SetReviewAuthorName result = new SetReviewAuthorName();
      result.authorName = this.authorName;
      return result;
    }

    public Builder authorName(String authorName) {
      this.authorName = authorName;
      return this;
    }
  }
}
