package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetReviewCustomer {
  private ResourceIdentifierInput customer;

  public SetReviewCustomer() {
  }

  public SetReviewCustomer(ResourceIdentifierInput customer) {
    this.customer = customer;
  }

  public ResourceIdentifierInput getCustomer() {
    return customer;
  }

  public void setCustomer(ResourceIdentifierInput customer) {
    this.customer = customer;
  }

  @Override
  public String toString() {
    return "SetReviewCustomer{customer='" + customer + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetReviewCustomer that = (SetReviewCustomer) o;
    return Objects.equals(customer, that.customer);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customer);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput customer;

    public SetReviewCustomer build() {
      SetReviewCustomer result = new SetReviewCustomer();
      result.customer = this.customer;
      return result;
    }

    public Builder customer(ResourceIdentifierInput customer) {
      this.customer = customer;
      return this;
    }
  }
}
