package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetReviewRating {
  private Integer rating;

  public SetReviewRating() {
  }

  public SetReviewRating(Integer rating) {
    this.rating = rating;
  }

  public Integer getRating() {
    return rating;
  }

  public void setRating(Integer rating) {
    this.rating = rating;
  }

  @Override
  public String toString() {
    return "SetReviewRating{rating='" + rating + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetReviewRating that = (SetReviewRating) o;
    return Objects.equals(rating, that.rating);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rating);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer rating;

    public SetReviewRating build() {
      SetReviewRating result = new SetReviewRating();
      result.rating = this.rating;
      return result;
    }

    public Builder rating(Integer rating) {
      this.rating = rating;
      return this;
    }
  }
}
