package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetReviewTarget {
  private TargetReferenceInput target;

  public SetReviewTarget() {
  }

  public SetReviewTarget(TargetReferenceInput target) {
    this.target = target;
  }

  public TargetReferenceInput getTarget() {
    return target;
  }

  public void setTarget(TargetReferenceInput target) {
    this.target = target;
  }

  @Override
  public String toString() {
    return "SetReviewTarget{target='" + target + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetReviewTarget that = (SetReviewTarget) o;
    return Objects.equals(target, that.target);
  }

  @Override
  public int hashCode() {
    return Objects.hash(target);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private TargetReferenceInput target;

    public SetReviewTarget build() {
      SetReviewTarget result = new SetReviewTarget();
      result.target = this.target;
      return result;
    }

    public Builder target(TargetReferenceInput target) {
      this.target = target;
      return this;
    }
  }
}
