package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetShippingMethodLocalizedDescription {
  private List<LocalizedStringItemInputType> localizedDescription;

  public SetShippingMethodLocalizedDescription() {
  }

  public SetShippingMethodLocalizedDescription(
      List<LocalizedStringItemInputType> localizedDescription) {
    this.localizedDescription = localizedDescription;
  }

  public List<LocalizedStringItemInputType> getLocalizedDescription() {
    return localizedDescription;
  }

  public void setLocalizedDescription(List<LocalizedStringItemInputType> localizedDescription) {
    this.localizedDescription = localizedDescription;
  }

  @Override
  public String toString() {
    return "SetShippingMethodLocalizedDescription{localizedDescription='" + localizedDescription + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetShippingMethodLocalizedDescription that = (SetShippingMethodLocalizedDescription) o;
    return Objects.equals(localizedDescription, that.localizedDescription);
  }

  @Override
  public int hashCode() {
    return Objects.hash(localizedDescription);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> localizedDescription;

    public SetShippingMethodLocalizedDescription build() {
      SetShippingMethodLocalizedDescription result = new SetShippingMethodLocalizedDescription();
      result.localizedDescription = this.localizedDescription;
      return result;
    }

    public Builder localizedDescription(List<LocalizedStringItemInputType> localizedDescription) {
      this.localizedDescription = localizedDescription;
      return this;
    }
  }
}
