package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetShippingMethodLocalizedName {
  private List<LocalizedStringItemInputType> localizedName;

  public SetShippingMethodLocalizedName() {
  }

  public SetShippingMethodLocalizedName(List<LocalizedStringItemInputType> localizedName) {
    this.localizedName = localizedName;
  }

  public List<LocalizedStringItemInputType> getLocalizedName() {
    return localizedName;
  }

  public void setLocalizedName(List<LocalizedStringItemInputType> localizedName) {
    this.localizedName = localizedName;
  }

  @Override
  public String toString() {
    return "SetShippingMethodLocalizedName{localizedName='" + localizedName + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetShippingMethodLocalizedName that = (SetShippingMethodLocalizedName) o;
    return Objects.equals(localizedName, that.localizedName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(localizedName);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> localizedName;

    public SetShippingMethodLocalizedName build() {
      SetShippingMethodLocalizedName result = new SetShippingMethodLocalizedName();
      result.localizedName = this.localizedName;
      return result;
    }

    public Builder localizedName(List<LocalizedStringItemInputType> localizedName) {
      this.localizedName = localizedName;
      return this;
    }
  }
}
