package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetShippingMethodPredicate {
  private String predicate;

  public SetShippingMethodPredicate() {
  }

  public SetShippingMethodPredicate(String predicate) {
    this.predicate = predicate;
  }

  public String getPredicate() {
    return predicate;
  }

  public void setPredicate(String predicate) {
    this.predicate = predicate;
  }

  @Override
  public String toString() {
    return "SetShippingMethodPredicate{predicate='" + predicate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetShippingMethodPredicate that = (SetShippingMethodPredicate) o;
    return Objects.equals(predicate, that.predicate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(predicate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String predicate;

    public SetShippingMethodPredicate build() {
      SetShippingMethodPredicate result = new SetShippingMethodPredicate();
      result.predicate = this.predicate;
      return result;
    }

    public Builder predicate(String predicate) {
      this.predicate = predicate;
      return this;
    }
  }
}
