package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetShoppingListLineItemCustomField {
  private String lineItemId;

  private String lineItemKey;

  private String name;

  private String value;

  public SetShoppingListLineItemCustomField() {
  }

  public SetShoppingListLineItemCustomField(String lineItemId, String lineItemKey, String name,
      String value) {
    this.lineItemId = lineItemId;
    this.lineItemKey = lineItemKey;
    this.name = name;
    this.value = value;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "SetShoppingListLineItemCustomField{lineItemId='" + lineItemId + "', lineItemKey='" + lineItemKey + "', name='" + name + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetShoppingListLineItemCustomField that = (SetShoppingListLineItemCustomField) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(lineItemKey, that.lineItemKey) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, lineItemKey, name, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private String lineItemKey;

    private String name;

    private String value;

    public SetShoppingListLineItemCustomField build() {
      SetShoppingListLineItemCustomField result = new SetShoppingListLineItemCustomField();
      result.lineItemId = this.lineItemId;
      result.lineItemKey = this.lineItemKey;
      result.name = this.name;
      result.value = this.value;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }
  }
}
