package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderBillingAddressCustomTypeOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private CustomFieldsCommand custom;

  public SetStagedOrderBillingAddressCustomTypeOutput() {
  }

  public SetStagedOrderBillingAddressCustomTypeOutput(String type, CustomFieldsCommand custom) {
    this.type = type;
    this.custom = custom;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public CustomFieldsCommand getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsCommand custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "SetStagedOrderBillingAddressCustomTypeOutput{type='" + type + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderBillingAddressCustomTypeOutput that = (SetStagedOrderBillingAddressCustomTypeOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private CustomFieldsCommand custom;

    public SetStagedOrderBillingAddressCustomTypeOutput build() {
      SetStagedOrderBillingAddressCustomTypeOutput result = new SetStagedOrderBillingAddressCustomTypeOutput();
      result.type = this.type;
      result.custom = this.custom;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder custom(CustomFieldsCommand custom) {
      this.custom = custom;
      return this;
    }
  }
}
