package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderBusinessUnitOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private ResourceIdentifier businessUnitResId;

  public SetStagedOrderBusinessUnitOutput() {
  }

  public SetStagedOrderBusinessUnitOutput(String type, ResourceIdentifier businessUnitResId) {
    this.type = type;
    this.businessUnitResId = businessUnitResId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ResourceIdentifier getBusinessUnitResId() {
    return businessUnitResId;
  }

  public void setBusinessUnitResId(ResourceIdentifier businessUnitResId) {
    this.businessUnitResId = businessUnitResId;
  }

  @Override
  public String toString() {
    return "SetStagedOrderBusinessUnitOutput{type='" + type + "', businessUnitResId='" + businessUnitResId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderBusinessUnitOutput that = (SetStagedOrderBusinessUnitOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(businessUnitResId, that.businessUnitResId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, businessUnitResId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private ResourceIdentifier businessUnitResId;

    public SetStagedOrderBusinessUnitOutput build() {
      SetStagedOrderBusinessUnitOutput result = new SetStagedOrderBusinessUnitOutput();
      result.type = this.type;
      result.businessUnitResId = this.businessUnitResId;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder businessUnitResId(ResourceIdentifier businessUnitResId) {
      this.businessUnitResId = businessUnitResId;
      return this;
    }
  }
}
