package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderCountry {
  private String country;

  public SetStagedOrderCountry() {
  }

  public SetStagedOrderCountry(String country) {
    this.country = country;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  @Override
  public String toString() {
    return "SetStagedOrderCountry{country='" + country + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderCountry that = (SetStagedOrderCountry) o;
    return Objects.equals(country, that.country);
  }

  @Override
  public int hashCode() {
    return Objects.hash(country);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String country;

    public SetStagedOrderCountry build() {
      SetStagedOrderCountry result = new SetStagedOrderCountry();
      result.country = this.country;
      return result;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }
  }
}
