package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderCountryOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String country;

  public SetStagedOrderCountryOutput() {
  }

  public SetStagedOrderCountryOutput(String type, String country) {
    this.type = type;
    this.country = country;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  @Override
  public String toString() {
    return "SetStagedOrderCountryOutput{type='" + type + "', country='" + country + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderCountryOutput that = (SetStagedOrderCountryOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(country, that.country);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, country);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String country;

    public SetStagedOrderCountryOutput build() {
      SetStagedOrderCountryOutput result = new SetStagedOrderCountryOutput();
      result.type = this.type;
      result.country = this.country;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }
  }
}
