package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderCustomLineItemShippingDetailsOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String customLineItemId;

  private String customLineItemKey;

  private ItemShippingDetailsDraftOutput shippingDetails;

  public SetStagedOrderCustomLineItemShippingDetailsOutput() {
  }

  public SetStagedOrderCustomLineItemShippingDetailsOutput(String type, String customLineItemId,
      String customLineItemKey, ItemShippingDetailsDraftOutput shippingDetails) {
    this.type = type;
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.shippingDetails = shippingDetails;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public ItemShippingDetailsDraftOutput getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetailsDraftOutput shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  @Override
  public String toString() {
    return "SetStagedOrderCustomLineItemShippingDetailsOutput{type='" + type + "', customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', shippingDetails='" + shippingDetails + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderCustomLineItemShippingDetailsOutput that = (SetStagedOrderCustomLineItemShippingDetailsOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(shippingDetails, that.shippingDetails);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, customLineItemId, customLineItemKey, shippingDetails);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String customLineItemId;

    private String customLineItemKey;

    private ItemShippingDetailsDraftOutput shippingDetails;

    public SetStagedOrderCustomLineItemShippingDetailsOutput build() {
      SetStagedOrderCustomLineItemShippingDetailsOutput result = new SetStagedOrderCustomLineItemShippingDetailsOutput();
      result.type = this.type;
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.shippingDetails = this.shippingDetails;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetailsDraftOutput shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }
  }
}
