package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderCustomLineItemTaxRate {
  private String customLineItemId;

  private String customLineItemKey;

  private ExternalTaxRateDraft externalTaxRate;

  private String shippingKey;

  public SetStagedOrderCustomLineItemTaxRate() {
  }

  public SetStagedOrderCustomLineItemTaxRate(String customLineItemId, String customLineItemKey,
      ExternalTaxRateDraft externalTaxRate, String shippingKey) {
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.externalTaxRate = externalTaxRate;
    this.shippingKey = shippingKey;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public ExternalTaxRateDraft getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraft externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderCustomLineItemTaxRate{customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', externalTaxRate='" + externalTaxRate + "', shippingKey='" + shippingKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderCustomLineItemTaxRate that = (SetStagedOrderCustomLineItemTaxRate) o;
    return Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(shippingKey, that.shippingKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customLineItemId, customLineItemKey, externalTaxRate, shippingKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customLineItemId;

    private String customLineItemKey;

    private ExternalTaxRateDraft externalTaxRate;

    private String shippingKey;

    public SetStagedOrderCustomLineItemTaxRate build() {
      SetStagedOrderCustomLineItemTaxRate result = new SetStagedOrderCustomLineItemTaxRate();
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.externalTaxRate = this.externalTaxRate;
      result.shippingKey = this.shippingKey;
      return result;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraft externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }
  }
}
