package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderCustomerId {
  private String customerId;

  public SetStagedOrderCustomerId() {
  }

  public SetStagedOrderCustomerId(String customerId) {
    this.customerId = customerId;
  }

  public String getCustomerId() {
    return customerId;
  }

  public void setCustomerId(String customerId) {
    this.customerId = customerId;
  }

  @Override
  public String toString() {
    return "SetStagedOrderCustomerId{customerId='" + customerId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderCustomerId that = (SetStagedOrderCustomerId) o;
    return Objects.equals(customerId, that.customerId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customerId;

    public SetStagedOrderCustomerId build() {
      SetStagedOrderCustomerId result = new SetStagedOrderCustomerId();
      result.customerId = this.customerId;
      return result;
    }

    public Builder customerId(String customerId) {
      this.customerId = customerId;
      return this;
    }
  }
}
