package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderCustomerIdOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String customerId;

  public SetStagedOrderCustomerIdOutput() {
  }

  public SetStagedOrderCustomerIdOutput(String type, String customerId) {
    this.type = type;
    this.customerId = customerId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getCustomerId() {
    return customerId;
  }

  public void setCustomerId(String customerId) {
    this.customerId = customerId;
  }

  @Override
  public String toString() {
    return "SetStagedOrderCustomerIdOutput{type='" + type + "', customerId='" + customerId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderCustomerIdOutput that = (SetStagedOrderCustomerIdOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(customerId, that.customerId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, customerId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String customerId;

    public SetStagedOrderCustomerIdOutput build() {
      SetStagedOrderCustomerIdOutput result = new SetStagedOrderCustomerIdOutput();
      result.type = this.type;
      result.customerId = this.customerId;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder customerId(String customerId) {
      this.customerId = customerId;
      return this;
    }
  }
}
