package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetStagedOrderDeliveryItems {
  private String deliveryId;

  private String deliveryKey;

  private List<DeliveryItemDraftType> items;

  public SetStagedOrderDeliveryItems() {
  }

  public SetStagedOrderDeliveryItems(String deliveryId, String deliveryKey,
      List<DeliveryItemDraftType> items) {
    this.deliveryId = deliveryId;
    this.deliveryKey = deliveryKey;
    this.items = items;
  }

  public String getDeliveryId() {
    return deliveryId;
  }

  public void setDeliveryId(String deliveryId) {
    this.deliveryId = deliveryId;
  }

  public String getDeliveryKey() {
    return deliveryKey;
  }

  public void setDeliveryKey(String deliveryKey) {
    this.deliveryKey = deliveryKey;
  }

  public List<DeliveryItemDraftType> getItems() {
    return items;
  }

  public void setItems(List<DeliveryItemDraftType> items) {
    this.items = items;
  }

  @Override
  public String toString() {
    return "SetStagedOrderDeliveryItems{deliveryId='" + deliveryId + "', deliveryKey='" + deliveryKey + "', items='" + items + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderDeliveryItems that = (SetStagedOrderDeliveryItems) o;
    return Objects.equals(deliveryId, that.deliveryId) &&
        Objects.equals(deliveryKey, that.deliveryKey) &&
        Objects.equals(items, that.items);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deliveryId, deliveryKey, items);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String deliveryId;

    private String deliveryKey;

    private List<DeliveryItemDraftType> items;

    public SetStagedOrderDeliveryItems build() {
      SetStagedOrderDeliveryItems result = new SetStagedOrderDeliveryItems();
      result.deliveryId = this.deliveryId;
      result.deliveryKey = this.deliveryKey;
      result.items = this.items;
      return result;
    }

    public Builder deliveryId(String deliveryId) {
      this.deliveryId = deliveryId;
      return this;
    }

    public Builder deliveryKey(String deliveryKey) {
      this.deliveryKey = deliveryKey;
      return this;
    }

    public Builder items(List<DeliveryItemDraftType> items) {
      this.items = items;
      return this;
    }
  }
}
