package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetStagedOrderDirectDiscounts {
  private List<DirectDiscountDraft> discounts;

  public SetStagedOrderDirectDiscounts() {
  }

  public SetStagedOrderDirectDiscounts(List<DirectDiscountDraft> discounts) {
    this.discounts = discounts;
  }

  public List<DirectDiscountDraft> getDiscounts() {
    return discounts;
  }

  public void setDiscounts(List<DirectDiscountDraft> discounts) {
    this.discounts = discounts;
  }

  @Override
  public String toString() {
    return "SetStagedOrderDirectDiscounts{discounts='" + discounts + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderDirectDiscounts that = (SetStagedOrderDirectDiscounts) o;
    return Objects.equals(discounts, that.discounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(discounts);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<DirectDiscountDraft> discounts;

    public SetStagedOrderDirectDiscounts build() {
      SetStagedOrderDirectDiscounts result = new SetStagedOrderDirectDiscounts();
      result.discounts = this.discounts;
      return result;
    }

    public Builder discounts(List<DirectDiscountDraft> discounts) {
      this.discounts = discounts;
      return this;
    }
  }
}
