package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderItemShippingAddressCustomTypeOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String addressKey;

  private CustomFieldsCommand custom;

  public SetStagedOrderItemShippingAddressCustomTypeOutput() {
  }

  public SetStagedOrderItemShippingAddressCustomTypeOutput(String type, String addressKey,
      CustomFieldsCommand custom) {
    this.type = type;
    this.addressKey = addressKey;
    this.custom = custom;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getAddressKey() {
    return addressKey;
  }

  public void setAddressKey(String addressKey) {
    this.addressKey = addressKey;
  }

  public CustomFieldsCommand getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsCommand custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "SetStagedOrderItemShippingAddressCustomTypeOutput{type='" + type + "', addressKey='" + addressKey + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderItemShippingAddressCustomTypeOutput that = (SetStagedOrderItemShippingAddressCustomTypeOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(addressKey, that.addressKey) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, addressKey, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String addressKey;

    private CustomFieldsCommand custom;

    public SetStagedOrderItemShippingAddressCustomTypeOutput build() {
      SetStagedOrderItemShippingAddressCustomTypeOutput result = new SetStagedOrderItemShippingAddressCustomTypeOutput();
      result.type = this.type;
      result.addressKey = this.addressKey;
      result.custom = this.custom;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder addressKey(String addressKey) {
      this.addressKey = addressKey;
      return this;
    }

    public Builder custom(CustomFieldsCommand custom) {
      this.custom = custom;
      return this;
    }
  }
}
