package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderLineItemCustomTypeOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String lineItemId;

  private CustomFieldsCommand custom;

  private String lineItemKey;

  public SetStagedOrderLineItemCustomTypeOutput() {
  }

  public SetStagedOrderLineItemCustomTypeOutput(String type, String lineItemId,
      CustomFieldsCommand custom, String lineItemKey) {
    this.type = type;
    this.lineItemId = lineItemId;
    this.custom = custom;
    this.lineItemKey = lineItemKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public CustomFieldsCommand getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsCommand custom) {
    this.custom = custom;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderLineItemCustomTypeOutput{type='" + type + "', lineItemId='" + lineItemId + "', custom='" + custom + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderLineItemCustomTypeOutput that = (SetStagedOrderLineItemCustomTypeOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, lineItemId, custom, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String lineItemId;

    private CustomFieldsCommand custom;

    private String lineItemKey;

    public SetStagedOrderLineItemCustomTypeOutput build() {
      SetStagedOrderLineItemCustomTypeOutput result = new SetStagedOrderLineItemCustomTypeOutput();
      result.type = this.type;
      result.lineItemId = this.lineItemId;
      result.custom = this.custom;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder custom(CustomFieldsCommand custom) {
      this.custom = custom;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
