package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderLineItemPrice {
  private String lineItemId;

  private BaseMoneyInput externalPrice;

  private String lineItemKey;

  public SetStagedOrderLineItemPrice() {
  }

  public SetStagedOrderLineItemPrice(String lineItemId, BaseMoneyInput externalPrice,
      String lineItemKey) {
    this.lineItemId = lineItemId;
    this.externalPrice = externalPrice;
    this.lineItemKey = lineItemKey;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public BaseMoneyInput getExternalPrice() {
    return externalPrice;
  }

  public void setExternalPrice(BaseMoneyInput externalPrice) {
    this.externalPrice = externalPrice;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderLineItemPrice{lineItemId='" + lineItemId + "', externalPrice='" + externalPrice + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderLineItemPrice that = (SetStagedOrderLineItemPrice) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(externalPrice, that.externalPrice) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, externalPrice, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private BaseMoneyInput externalPrice;

    private String lineItemKey;

    public SetStagedOrderLineItemPrice build() {
      SetStagedOrderLineItemPrice result = new SetStagedOrderLineItemPrice();
      result.lineItemId = this.lineItemId;
      result.externalPrice = this.externalPrice;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder externalPrice(BaseMoneyInput externalPrice) {
      this.externalPrice = externalPrice;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
