package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderLineItemTaxRateOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String lineItemId;

  private ExternalTaxRateDraftOutput externalTaxRate;

  private String shippingKey;

  private String lineItemKey;

  public SetStagedOrderLineItemTaxRateOutput() {
  }

  public SetStagedOrderLineItemTaxRateOutput(String type, String lineItemId,
      ExternalTaxRateDraftOutput externalTaxRate, String shippingKey, String lineItemKey) {
    this.type = type;
    this.lineItemId = lineItemId;
    this.externalTaxRate = externalTaxRate;
    this.shippingKey = shippingKey;
    this.lineItemKey = lineItemKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public ExternalTaxRateDraftOutput getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraftOutput externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderLineItemTaxRateOutput{type='" + type + "', lineItemId='" + lineItemId + "', externalTaxRate='" + externalTaxRate + "', shippingKey='" + shippingKey + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderLineItemTaxRateOutput that = (SetStagedOrderLineItemTaxRateOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, lineItemId, externalTaxRate, shippingKey, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String lineItemId;

    private ExternalTaxRateDraftOutput externalTaxRate;

    private String shippingKey;

    private String lineItemKey;

    public SetStagedOrderLineItemTaxRateOutput build() {
      SetStagedOrderLineItemTaxRateOutput result = new SetStagedOrderLineItemTaxRateOutput();
      result.type = this.type;
      result.lineItemId = this.lineItemId;
      result.externalTaxRate = this.externalTaxRate;
      result.shippingKey = this.shippingKey;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraftOutput externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
