package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SetStagedOrderOrderTotalTax {
  private MoneyInput externalTotalGross;

  private List<TaxPortionDraft> externalTaxPortions = Collections.emptyList();

  public SetStagedOrderOrderTotalTax() {
  }

  public SetStagedOrderOrderTotalTax(MoneyInput externalTotalGross,
      List<TaxPortionDraft> externalTaxPortions) {
    this.externalTotalGross = externalTotalGross;
    this.externalTaxPortions = externalTaxPortions;
  }

  public MoneyInput getExternalTotalGross() {
    return externalTotalGross;
  }

  public void setExternalTotalGross(MoneyInput externalTotalGross) {
    this.externalTotalGross = externalTotalGross;
  }

  public List<TaxPortionDraft> getExternalTaxPortions() {
    return externalTaxPortions;
  }

  public void setExternalTaxPortions(List<TaxPortionDraft> externalTaxPortions) {
    this.externalTaxPortions = externalTaxPortions;
  }

  @Override
  public String toString() {
    return "SetStagedOrderOrderTotalTax{externalTotalGross='" + externalTotalGross + "', externalTaxPortions='" + externalTaxPortions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderOrderTotalTax that = (SetStagedOrderOrderTotalTax) o;
    return Objects.equals(externalTotalGross, that.externalTotalGross) &&
        Objects.equals(externalTaxPortions, that.externalTaxPortions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(externalTotalGross, externalTaxPortions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private MoneyInput externalTotalGross;

    private List<TaxPortionDraft> externalTaxPortions = Collections.emptyList();

    public SetStagedOrderOrderTotalTax build() {
      SetStagedOrderOrderTotalTax result = new SetStagedOrderOrderTotalTax();
      result.externalTotalGross = this.externalTotalGross;
      result.externalTaxPortions = this.externalTaxPortions;
      return result;
    }

    public Builder externalTotalGross(MoneyInput externalTotalGross) {
      this.externalTotalGross = externalTotalGross;
      return this;
    }

    public Builder externalTaxPortions(List<TaxPortionDraft> externalTaxPortions) {
      this.externalTaxPortions = externalTaxPortions;
      return this;
    }
  }
}
