package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderParcelCustomFieldOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String name;

  private JsonNode value;

  private String parcelId;

  private String parcelKey;

  public SetStagedOrderParcelCustomFieldOutput() {
  }

  public SetStagedOrderParcelCustomFieldOutput(String type, String name, JsonNode value,
      String parcelId, String parcelKey) {
    this.type = type;
    this.name = name;
    this.value = value;
    this.parcelId = parcelId;
    this.parcelKey = parcelKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JsonNode getValue() {
    return value;
  }

  public void setValue(JsonNode value) {
    this.value = value;
  }

  public String getParcelId() {
    return parcelId;
  }

  public void setParcelId(String parcelId) {
    this.parcelId = parcelId;
  }

  public String getParcelKey() {
    return parcelKey;
  }

  public void setParcelKey(String parcelKey) {
    this.parcelKey = parcelKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderParcelCustomFieldOutput{type='" + type + "', name='" + name + "', value='" + value + "', parcelId='" + parcelId + "', parcelKey='" + parcelKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderParcelCustomFieldOutput that = (SetStagedOrderParcelCustomFieldOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value) &&
        Objects.equals(parcelId, that.parcelId) &&
        Objects.equals(parcelKey, that.parcelKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, name, value, parcelId, parcelKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String name;

    private JsonNode value;

    private String parcelId;

    private String parcelKey;

    public SetStagedOrderParcelCustomFieldOutput build() {
      SetStagedOrderParcelCustomFieldOutput result = new SetStagedOrderParcelCustomFieldOutput();
      result.type = this.type;
      result.name = this.name;
      result.value = this.value;
      result.parcelId = this.parcelId;
      result.parcelKey = this.parcelKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(JsonNode value) {
      this.value = value;
      return this;
    }

    public Builder parcelId(String parcelId) {
      this.parcelId = parcelId;
      return this;
    }

    public Builder parcelKey(String parcelKey) {
      this.parcelKey = parcelKey;
      return this;
    }
  }
}
