package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderParcelMeasurementsOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String parcelId;

  private String parcelKey;

  private ParcelMeasurements measurements;

  public SetStagedOrderParcelMeasurementsOutput() {
  }

  public SetStagedOrderParcelMeasurementsOutput(String type, String parcelId, String parcelKey,
      ParcelMeasurements measurements) {
    this.type = type;
    this.parcelId = parcelId;
    this.parcelKey = parcelKey;
    this.measurements = measurements;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getParcelId() {
    return parcelId;
  }

  public void setParcelId(String parcelId) {
    this.parcelId = parcelId;
  }

  public String getParcelKey() {
    return parcelKey;
  }

  public void setParcelKey(String parcelKey) {
    this.parcelKey = parcelKey;
  }

  public ParcelMeasurements getMeasurements() {
    return measurements;
  }

  public void setMeasurements(ParcelMeasurements measurements) {
    this.measurements = measurements;
  }

  @Override
  public String toString() {
    return "SetStagedOrderParcelMeasurementsOutput{type='" + type + "', parcelId='" + parcelId + "', parcelKey='" + parcelKey + "', measurements='" + measurements + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderParcelMeasurementsOutput that = (SetStagedOrderParcelMeasurementsOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(parcelId, that.parcelId) &&
        Objects.equals(parcelKey, that.parcelKey) &&
        Objects.equals(measurements, that.measurements);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, parcelId, parcelKey, measurements);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String parcelId;

    private String parcelKey;

    private ParcelMeasurements measurements;

    public SetStagedOrderParcelMeasurementsOutput build() {
      SetStagedOrderParcelMeasurementsOutput result = new SetStagedOrderParcelMeasurementsOutput();
      result.type = this.type;
      result.parcelId = this.parcelId;
      result.parcelKey = this.parcelKey;
      result.measurements = this.measurements;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder parcelId(String parcelId) {
      this.parcelId = parcelId;
      return this;
    }

    public Builder parcelKey(String parcelKey) {
      this.parcelKey = parcelKey;
      return this;
    }

    public Builder measurements(ParcelMeasurements measurements) {
      this.measurements = measurements;
      return this;
    }
  }
}
