package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderParcelTrackingData {
  private String parcelId;

  private String parcelKey;

  private TrackingDataDraftType trackingData;

  public SetStagedOrderParcelTrackingData() {
  }

  public SetStagedOrderParcelTrackingData(String parcelId, String parcelKey,
      TrackingDataDraftType trackingData) {
    this.parcelId = parcelId;
    this.parcelKey = parcelKey;
    this.trackingData = trackingData;
  }

  public String getParcelId() {
    return parcelId;
  }

  public void setParcelId(String parcelId) {
    this.parcelId = parcelId;
  }

  public String getParcelKey() {
    return parcelKey;
  }

  public void setParcelKey(String parcelKey) {
    this.parcelKey = parcelKey;
  }

  public TrackingDataDraftType getTrackingData() {
    return trackingData;
  }

  public void setTrackingData(TrackingDataDraftType trackingData) {
    this.trackingData = trackingData;
  }

  @Override
  public String toString() {
    return "SetStagedOrderParcelTrackingData{parcelId='" + parcelId + "', parcelKey='" + parcelKey + "', trackingData='" + trackingData + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderParcelTrackingData that = (SetStagedOrderParcelTrackingData) o;
    return Objects.equals(parcelId, that.parcelId) &&
        Objects.equals(parcelKey, that.parcelKey) &&
        Objects.equals(trackingData, that.trackingData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(parcelId, parcelKey, trackingData);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String parcelId;

    private String parcelKey;

    private TrackingDataDraftType trackingData;

    public SetStagedOrderParcelTrackingData build() {
      SetStagedOrderParcelTrackingData result = new SetStagedOrderParcelTrackingData();
      result.parcelId = this.parcelId;
      result.parcelKey = this.parcelKey;
      result.trackingData = this.trackingData;
      return result;
    }

    public Builder parcelId(String parcelId) {
      this.parcelId = parcelId;
      return this;
    }

    public Builder parcelKey(String parcelKey) {
      this.parcelKey = parcelKey;
      return this;
    }

    public Builder trackingData(TrackingDataDraftType trackingData) {
      this.trackingData = trackingData;
      return this;
    }
  }
}
