package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderPurchaseOrderNumber {
  private String purchaseOrderNumber;

  public SetStagedOrderPurchaseOrderNumber() {
  }

  public SetStagedOrderPurchaseOrderNumber(String purchaseOrderNumber) {
    this.purchaseOrderNumber = purchaseOrderNumber;
  }

  public String getPurchaseOrderNumber() {
    return purchaseOrderNumber;
  }

  public void setPurchaseOrderNumber(String purchaseOrderNumber) {
    this.purchaseOrderNumber = purchaseOrderNumber;
  }

  @Override
  public String toString() {
    return "SetStagedOrderPurchaseOrderNumber{purchaseOrderNumber='" + purchaseOrderNumber + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderPurchaseOrderNumber that = (SetStagedOrderPurchaseOrderNumber) o;
    return Objects.equals(purchaseOrderNumber, that.purchaseOrderNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(purchaseOrderNumber);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String purchaseOrderNumber;

    public SetStagedOrderPurchaseOrderNumber build() {
      SetStagedOrderPurchaseOrderNumber result = new SetStagedOrderPurchaseOrderNumber();
      result.purchaseOrderNumber = this.purchaseOrderNumber;
      return result;
    }

    public Builder purchaseOrderNumber(String purchaseOrderNumber) {
      this.purchaseOrderNumber = purchaseOrderNumber;
      return this;
    }
  }
}
