package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderPurchaseOrderNumberOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String purchaseOrderNumber;

  public SetStagedOrderPurchaseOrderNumberOutput() {
  }

  public SetStagedOrderPurchaseOrderNumberOutput(String type, String purchaseOrderNumber) {
    this.type = type;
    this.purchaseOrderNumber = purchaseOrderNumber;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getPurchaseOrderNumber() {
    return purchaseOrderNumber;
  }

  public void setPurchaseOrderNumber(String purchaseOrderNumber) {
    this.purchaseOrderNumber = purchaseOrderNumber;
  }

  @Override
  public String toString() {
    return "SetStagedOrderPurchaseOrderNumberOutput{type='" + type + "', purchaseOrderNumber='" + purchaseOrderNumber + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderPurchaseOrderNumberOutput that = (SetStagedOrderPurchaseOrderNumberOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(purchaseOrderNumber, that.purchaseOrderNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, purchaseOrderNumber);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String purchaseOrderNumber;

    public SetStagedOrderPurchaseOrderNumberOutput build() {
      SetStagedOrderPurchaseOrderNumberOutput result = new SetStagedOrderPurchaseOrderNumberOutput();
      result.type = this.type;
      result.purchaseOrderNumber = this.purchaseOrderNumber;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder purchaseOrderNumber(String purchaseOrderNumber) {
      this.purchaseOrderNumber = purchaseOrderNumber;
      return this;
    }
  }
}
