package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderReturnItemCustomTypeOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private CustomFieldsCommand custom;

  private String returnItemId;

  private String returnItemKey;

  public SetStagedOrderReturnItemCustomTypeOutput() {
  }

  public SetStagedOrderReturnItemCustomTypeOutput(String type, CustomFieldsCommand custom,
      String returnItemId, String returnItemKey) {
    this.type = type;
    this.custom = custom;
    this.returnItemId = returnItemId;
    this.returnItemKey = returnItemKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public CustomFieldsCommand getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsCommand custom) {
    this.custom = custom;
  }

  public String getReturnItemId() {
    return returnItemId;
  }

  public void setReturnItemId(String returnItemId) {
    this.returnItemId = returnItemId;
  }

  public String getReturnItemKey() {
    return returnItemKey;
  }

  public void setReturnItemKey(String returnItemKey) {
    this.returnItemKey = returnItemKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderReturnItemCustomTypeOutput{type='" + type + "', custom='" + custom + "', returnItemId='" + returnItemId + "', returnItemKey='" + returnItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderReturnItemCustomTypeOutput that = (SetStagedOrderReturnItemCustomTypeOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(returnItemId, that.returnItemId) &&
        Objects.equals(returnItemKey, that.returnItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, custom, returnItemId, returnItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private CustomFieldsCommand custom;

    private String returnItemId;

    private String returnItemKey;

    public SetStagedOrderReturnItemCustomTypeOutput build() {
      SetStagedOrderReturnItemCustomTypeOutput result = new SetStagedOrderReturnItemCustomTypeOutput();
      result.type = this.type;
      result.custom = this.custom;
      result.returnItemId = this.returnItemId;
      result.returnItemKey = this.returnItemKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder custom(CustomFieldsCommand custom) {
      this.custom = custom;
      return this;
    }

    public Builder returnItemId(String returnItemId) {
      this.returnItemId = returnItemId;
      return this;
    }

    public Builder returnItemKey(String returnItemKey) {
      this.returnItemKey = returnItemKey;
      return this;
    }
  }
}
