package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderReturnPaymentStateOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String returnItemId;

  private String returnItemKey;

  private ReturnPaymentState paymentState;

  public SetStagedOrderReturnPaymentStateOutput() {
  }

  public SetStagedOrderReturnPaymentStateOutput(String type, String returnItemId,
      String returnItemKey, ReturnPaymentState paymentState) {
    this.type = type;
    this.returnItemId = returnItemId;
    this.returnItemKey = returnItemKey;
    this.paymentState = paymentState;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getReturnItemId() {
    return returnItemId;
  }

  public void setReturnItemId(String returnItemId) {
    this.returnItemId = returnItemId;
  }

  public String getReturnItemKey() {
    return returnItemKey;
  }

  public void setReturnItemKey(String returnItemKey) {
    this.returnItemKey = returnItemKey;
  }

  public ReturnPaymentState getPaymentState() {
    return paymentState;
  }

  public void setPaymentState(ReturnPaymentState paymentState) {
    this.paymentState = paymentState;
  }

  @Override
  public String toString() {
    return "SetStagedOrderReturnPaymentStateOutput{type='" + type + "', returnItemId='" + returnItemId + "', returnItemKey='" + returnItemKey + "', paymentState='" + paymentState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderReturnPaymentStateOutput that = (SetStagedOrderReturnPaymentStateOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(returnItemId, that.returnItemId) &&
        Objects.equals(returnItemKey, that.returnItemKey) &&
        Objects.equals(paymentState, that.paymentState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, returnItemId, returnItemKey, paymentState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String returnItemId;

    private String returnItemKey;

    private ReturnPaymentState paymentState;

    public SetStagedOrderReturnPaymentStateOutput build() {
      SetStagedOrderReturnPaymentStateOutput result = new SetStagedOrderReturnPaymentStateOutput();
      result.type = this.type;
      result.returnItemId = this.returnItemId;
      result.returnItemKey = this.returnItemKey;
      result.paymentState = this.paymentState;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder returnItemId(String returnItemId) {
      this.returnItemId = returnItemId;
      return this;
    }

    public Builder returnItemKey(String returnItemKey) {
      this.returnItemKey = returnItemKey;
      return this;
    }

    public Builder paymentState(ReturnPaymentState paymentState) {
      this.paymentState = paymentState;
      return this;
    }
  }
}
