package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderReturnShipmentStateOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String returnItemId;

  private String returnItemKey;

  private ReturnShipmentState shipmentState;

  public SetStagedOrderReturnShipmentStateOutput() {
  }

  public SetStagedOrderReturnShipmentStateOutput(String type, String returnItemId,
      String returnItemKey, ReturnShipmentState shipmentState) {
    this.type = type;
    this.returnItemId = returnItemId;
    this.returnItemKey = returnItemKey;
    this.shipmentState = shipmentState;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getReturnItemId() {
    return returnItemId;
  }

  public void setReturnItemId(String returnItemId) {
    this.returnItemId = returnItemId;
  }

  public String getReturnItemKey() {
    return returnItemKey;
  }

  public void setReturnItemKey(String returnItemKey) {
    this.returnItemKey = returnItemKey;
  }

  public ReturnShipmentState getShipmentState() {
    return shipmentState;
  }

  public void setShipmentState(ReturnShipmentState shipmentState) {
    this.shipmentState = shipmentState;
  }

  @Override
  public String toString() {
    return "SetStagedOrderReturnShipmentStateOutput{type='" + type + "', returnItemId='" + returnItemId + "', returnItemKey='" + returnItemKey + "', shipmentState='" + shipmentState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderReturnShipmentStateOutput that = (SetStagedOrderReturnShipmentStateOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(returnItemId, that.returnItemId) &&
        Objects.equals(returnItemKey, that.returnItemKey) &&
        Objects.equals(shipmentState, that.shipmentState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, returnItemId, returnItemKey, shipmentState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String returnItemId;

    private String returnItemKey;

    private ReturnShipmentState shipmentState;

    public SetStagedOrderReturnShipmentStateOutput build() {
      SetStagedOrderReturnShipmentStateOutput result = new SetStagedOrderReturnShipmentStateOutput();
      result.type = this.type;
      result.returnItemId = this.returnItemId;
      result.returnItemKey = this.returnItemKey;
      result.shipmentState = this.shipmentState;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder returnItemId(String returnItemId) {
      this.returnItemId = returnItemId;
      return this;
    }

    public Builder returnItemKey(String returnItemKey) {
      this.returnItemKey = returnItemKey;
      return this;
    }

    public Builder shipmentState(ReturnShipmentState shipmentState) {
      this.shipmentState = shipmentState;
      return this;
    }
  }
}
