package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderShippingAddressOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private AddressDraft address;

  public SetStagedOrderShippingAddressOutput() {
  }

  public SetStagedOrderShippingAddressOutput(String type, AddressDraft address) {
    this.type = type;
    this.address = address;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public AddressDraft getAddress() {
    return address;
  }

  public void setAddress(AddressDraft address) {
    this.address = address;
  }

  @Override
  public String toString() {
    return "SetStagedOrderShippingAddressOutput{type='" + type + "', address='" + address + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderShippingAddressOutput that = (SetStagedOrderShippingAddressOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(address, that.address);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, address);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private AddressDraft address;

    public SetStagedOrderShippingAddressOutput build() {
      SetStagedOrderShippingAddressOutput result = new SetStagedOrderShippingAddressOutput();
      result.type = this.type;
      result.address = this.address;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder address(AddressDraft address) {
      this.address = address;
      return this;
    }
  }
}
