package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderShippingCustomField {
  private String shippingKey;

  private String name;

  private String value;

  public SetStagedOrderShippingCustomField() {
  }

  public SetStagedOrderShippingCustomField(String shippingKey, String name, String value) {
    this.shippingKey = shippingKey;
    this.name = name;
    this.value = value;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "SetStagedOrderShippingCustomField{shippingKey='" + shippingKey + "', name='" + name + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderShippingCustomField that = (SetStagedOrderShippingCustomField) o;
    return Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingKey, name, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String shippingKey;

    private String name;

    private String value;

    public SetStagedOrderShippingCustomField build() {
      SetStagedOrderShippingCustomField result = new SetStagedOrderShippingCustomField();
      result.shippingKey = this.shippingKey;
      result.name = this.name;
      result.value = this.value;
      return result;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }
  }
}
