package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderShippingCustomTypeOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private String shippingKey;

  private CustomFieldsCommand custom;

  public SetStagedOrderShippingCustomTypeOutput() {
  }

  public SetStagedOrderShippingCustomTypeOutput(String type, String shippingKey,
      CustomFieldsCommand custom) {
    this.type = type;
    this.shippingKey = shippingKey;
    this.custom = custom;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  public CustomFieldsCommand getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsCommand custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "SetStagedOrderShippingCustomTypeOutput{type='" + type + "', shippingKey='" + shippingKey + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderShippingCustomTypeOutput that = (SetStagedOrderShippingCustomTypeOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(shippingKey, that.shippingKey) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, shippingKey, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private String shippingKey;

    private CustomFieldsCommand custom;

    public SetStagedOrderShippingCustomTypeOutput build() {
      SetStagedOrderShippingCustomTypeOutput result = new SetStagedOrderShippingCustomTypeOutput();
      result.type = this.type;
      result.shippingKey = this.shippingKey;
      result.custom = this.custom;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }

    public Builder custom(CustomFieldsCommand custom) {
      this.custom = custom;
      return this;
    }
  }
}
