package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderShippingMethodOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private ResourceIdentifier shippingMethodResId;

  private ExternalTaxRateDraftOutput externalTaxRate;

  public SetStagedOrderShippingMethodOutput() {
  }

  public SetStagedOrderShippingMethodOutput(String type, ResourceIdentifier shippingMethodResId,
      ExternalTaxRateDraftOutput externalTaxRate) {
    this.type = type;
    this.shippingMethodResId = shippingMethodResId;
    this.externalTaxRate = externalTaxRate;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ResourceIdentifier getShippingMethodResId() {
    return shippingMethodResId;
  }

  public void setShippingMethodResId(ResourceIdentifier shippingMethodResId) {
    this.shippingMethodResId = shippingMethodResId;
  }

  public ExternalTaxRateDraftOutput getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraftOutput externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  @Override
  public String toString() {
    return "SetStagedOrderShippingMethodOutput{type='" + type + "', shippingMethodResId='" + shippingMethodResId + "', externalTaxRate='" + externalTaxRate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderShippingMethodOutput that = (SetStagedOrderShippingMethodOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(shippingMethodResId, that.shippingMethodResId) &&
        Objects.equals(externalTaxRate, that.externalTaxRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, shippingMethodResId, externalTaxRate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private ResourceIdentifier shippingMethodResId;

    private ExternalTaxRateDraftOutput externalTaxRate;

    public SetStagedOrderShippingMethodOutput build() {
      SetStagedOrderShippingMethodOutput result = new SetStagedOrderShippingMethodOutput();
      result.type = this.type;
      result.shippingMethodResId = this.shippingMethodResId;
      result.externalTaxRate = this.externalTaxRate;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder shippingMethodResId(ResourceIdentifier shippingMethodResId) {
      this.shippingMethodResId = shippingMethodResId;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraftOutput externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }
  }
}
