package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderShippingMethodTaxAmountOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private ExternalTaxAmountDraftOutput externalTaxAmount;

  private String shippingKey;

  public SetStagedOrderShippingMethodTaxAmountOutput() {
  }

  public SetStagedOrderShippingMethodTaxAmountOutput(String type,
      ExternalTaxAmountDraftOutput externalTaxAmount, String shippingKey) {
    this.type = type;
    this.externalTaxAmount = externalTaxAmount;
    this.shippingKey = shippingKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ExternalTaxAmountDraftOutput getExternalTaxAmount() {
    return externalTaxAmount;
  }

  public void setExternalTaxAmount(ExternalTaxAmountDraftOutput externalTaxAmount) {
    this.externalTaxAmount = externalTaxAmount;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderShippingMethodTaxAmountOutput{type='" + type + "', externalTaxAmount='" + externalTaxAmount + "', shippingKey='" + shippingKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderShippingMethodTaxAmountOutput that = (SetStagedOrderShippingMethodTaxAmountOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(externalTaxAmount, that.externalTaxAmount) &&
        Objects.equals(shippingKey, that.shippingKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, externalTaxAmount, shippingKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private ExternalTaxAmountDraftOutput externalTaxAmount;

    private String shippingKey;

    public SetStagedOrderShippingMethodTaxAmountOutput build() {
      SetStagedOrderShippingMethodTaxAmountOutput result = new SetStagedOrderShippingMethodTaxAmountOutput();
      result.type = this.type;
      result.externalTaxAmount = this.externalTaxAmount;
      result.shippingKey = this.shippingKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder externalTaxAmount(ExternalTaxAmountDraftOutput externalTaxAmount) {
      this.externalTaxAmount = externalTaxAmount;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }
  }
}
