package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStagedOrderShippingMethodTaxRate {
  private ExternalTaxRateDraft externalTaxRate;

  private String shippingKey;

  public SetStagedOrderShippingMethodTaxRate() {
  }

  public SetStagedOrderShippingMethodTaxRate(ExternalTaxRateDraft externalTaxRate,
      String shippingKey) {
    this.externalTaxRate = externalTaxRate;
    this.shippingKey = shippingKey;
  }

  public ExternalTaxRateDraft getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraft externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderShippingMethodTaxRate{externalTaxRate='" + externalTaxRate + "', shippingKey='" + shippingKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderShippingMethodTaxRate that = (SetStagedOrderShippingMethodTaxRate) o;
    return Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(shippingKey, that.shippingKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(externalTaxRate, shippingKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ExternalTaxRateDraft externalTaxRate;

    private String shippingKey;

    public SetStagedOrderShippingMethodTaxRate build() {
      SetStagedOrderShippingMethodTaxRate result = new SetStagedOrderShippingMethodTaxRate();
      result.externalTaxRate = this.externalTaxRate;
      result.shippingKey = this.shippingKey;
      return result;
    }

    public Builder externalTaxRate(ExternalTaxRateDraft externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }
  }
}
