package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderShippingMethodTaxRateOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private ExternalTaxRateDraftOutput externalTaxRate;

  private String shippingKey;

  public SetStagedOrderShippingMethodTaxRateOutput() {
  }

  public SetStagedOrderShippingMethodTaxRateOutput(String type,
      ExternalTaxRateDraftOutput externalTaxRate, String shippingKey) {
    this.type = type;
    this.externalTaxRate = externalTaxRate;
    this.shippingKey = shippingKey;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ExternalTaxRateDraftOutput getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraftOutput externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  @Override
  public String toString() {
    return "SetStagedOrderShippingMethodTaxRateOutput{type='" + type + "', externalTaxRate='" + externalTaxRate + "', shippingKey='" + shippingKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderShippingMethodTaxRateOutput that = (SetStagedOrderShippingMethodTaxRateOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(shippingKey, that.shippingKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, externalTaxRate, shippingKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private ExternalTaxRateDraftOutput externalTaxRate;

    private String shippingKey;

    public SetStagedOrderShippingMethodTaxRateOutput build() {
      SetStagedOrderShippingMethodTaxRateOutput result = new SetStagedOrderShippingMethodTaxRateOutput();
      result.type = this.type;
      result.externalTaxRate = this.externalTaxRate;
      result.shippingKey = this.shippingKey;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraftOutput externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }
  }
}
