package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class SetStagedOrderStoreOutput implements com.commercetools.graphql.api.types.StagedOrderUpdateActionOutput {
  private String type;

  private ResourceIdentifier storeResId;

  public SetStagedOrderStoreOutput() {
  }

  public SetStagedOrderStoreOutput(String type, ResourceIdentifier storeResId) {
    this.type = type;
    this.storeResId = storeResId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ResourceIdentifier getStoreResId() {
    return storeResId;
  }

  public void setStoreResId(ResourceIdentifier storeResId) {
    this.storeResId = storeResId;
  }

  @Override
  public String toString() {
    return "SetStagedOrderStoreOutput{type='" + type + "', storeResId='" + storeResId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedOrderStoreOutput that = (SetStagedOrderStoreOutput) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(storeResId, that.storeResId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, storeResId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private ResourceIdentifier storeResId;

    public SetStagedOrderStoreOutput build() {
      SetStagedOrderStoreOutput result = new SetStagedOrderStoreOutput();
      result.type = this.type;
      result.storeResId = this.storeResId;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder storeResId(ResourceIdentifier storeResId) {
      this.storeResId = storeResId;
      return this;
    }
  }
}
