package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SetStagedQuoteValidTo {
  private OffsetDateTime validTo;

  public SetStagedQuoteValidTo() {
  }

  public SetStagedQuoteValidTo(OffsetDateTime validTo) {
    this.validTo = validTo;
  }

  public OffsetDateTime getValidTo() {
    return validTo;
  }

  public void setValidTo(OffsetDateTime validTo) {
    this.validTo = validTo;
  }

  @Override
  public String toString() {
    return "SetStagedQuoteValidTo{validTo='" + validTo + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStagedQuoteValidTo that = (SetStagedQuoteValidTo) o;
    return Objects.equals(validTo, that.validTo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(validTo);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime validTo;

    public SetStagedQuoteValidTo build() {
      SetStagedQuoteValidTo result = new SetStagedQuoteValidTo();
      result.validTo = this.validTo;
      return result;
    }

    public Builder validTo(OffsetDateTime validTo) {
      this.validTo = validTo;
      return this;
    }
  }
}
