package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetStandalonePriceKey {
  private String key;

  public SetStandalonePriceKey() {
  }

  public SetStandalonePriceKey(String key) {
    this.key = key;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  @Override
  public String toString() {
    return "SetStandalonePriceKey{key='" + key + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStandalonePriceKey that = (SetStandalonePriceKey) o;
    return Objects.equals(key, that.key);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    public SetStandalonePriceKey build() {
      SetStandalonePriceKey result = new SetStandalonePriceKey();
      result.key = this.key;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }
  }
}
