package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SetStandalonePriceValidUntil {
  private OffsetDateTime validUntil;

  public SetStandalonePriceValidUntil() {
  }

  public SetStandalonePriceValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  @Override
  public String toString() {
    return "SetStandalonePriceValidUntil{validUntil='" + validUntil + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStandalonePriceValidUntil that = (SetStandalonePriceValidUntil) o;
    return Objects.equals(validUntil, that.validUntil);
  }

  @Override
  public int hashCode() {
    return Objects.hash(validUntil);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime validUntil;

    public SetStandalonePriceValidUntil build() {
      SetStandalonePriceValidUntil result = new SetStandalonePriceValidUntil();
      result.validUntil = this.validUntil;
      return result;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }
  }
}
