package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetStoreProductSelections {
  private List<ProductSelectionSettingInActionInput> productSelections;

  public SetStoreProductSelections() {
  }

  public SetStoreProductSelections(List<ProductSelectionSettingInActionInput> productSelections) {
    this.productSelections = productSelections;
  }

  public List<ProductSelectionSettingInActionInput> getProductSelections() {
    return productSelections;
  }

  public void setProductSelections(List<ProductSelectionSettingInActionInput> productSelections) {
    this.productSelections = productSelections;
  }

  @Override
  public String toString() {
    return "SetStoreProductSelections{productSelections='" + productSelections + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetStoreProductSelections that = (SetStoreProductSelections) o;
    return Objects.equals(productSelections, that.productSelections);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productSelections);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ProductSelectionSettingInActionInput> productSelections;

    public SetStoreProductSelections build() {
      SetStoreProductSelections result = new SetStoreProductSelections();
      result.productSelections = this.productSelections;
      return result;
    }

    public Builder productSelections(List<ProductSelectionSettingInActionInput> productSelections) {
      this.productSelections = productSelections;
      return this;
    }
  }
}
