package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetSubscriptionMessages {
  private List<MessageSubscriptionInput> messages;

  public SetSubscriptionMessages() {
  }

  public SetSubscriptionMessages(List<MessageSubscriptionInput> messages) {
    this.messages = messages;
  }

  public List<MessageSubscriptionInput> getMessages() {
    return messages;
  }

  public void setMessages(List<MessageSubscriptionInput> messages) {
    this.messages = messages;
  }

  @Override
  public String toString() {
    return "SetSubscriptionMessages{messages='" + messages + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetSubscriptionMessages that = (SetSubscriptionMessages) o;
    return Objects.equals(messages, that.messages);
  }

  @Override
  public int hashCode() {
    return Objects.hash(messages);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<MessageSubscriptionInput> messages;

    public SetSubscriptionMessages build() {
      SetSubscriptionMessages result = new SetSubscriptionMessages();
      result.messages = this.messages;
      return result;
    }

    public Builder messages(List<MessageSubscriptionInput> messages) {
      this.messages = messages;
      return this;
    }
  }
}
