package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ShippingContainer {
  private ShippingMode shippingMode;

  private Shipping singleShipping;

  private List<Shipping> multiShipping;

  public ShippingContainer() {
  }

  public ShippingContainer(ShippingMode shippingMode, Shipping singleShipping,
      List<Shipping> multiShipping) {
    this.shippingMode = shippingMode;
    this.singleShipping = singleShipping;
    this.multiShipping = multiShipping;
  }

  public ShippingMode getShippingMode() {
    return shippingMode;
  }

  public void setShippingMode(ShippingMode shippingMode) {
    this.shippingMode = shippingMode;
  }

  public Shipping getSingleShipping() {
    return singleShipping;
  }

  public void setSingleShipping(Shipping singleShipping) {
    this.singleShipping = singleShipping;
  }

  public List<Shipping> getMultiShipping() {
    return multiShipping;
  }

  public void setMultiShipping(List<Shipping> multiShipping) {
    this.multiShipping = multiShipping;
  }

  @Override
  public String toString() {
    return "ShippingContainer{shippingMode='" + shippingMode + "', singleShipping='" + singleShipping + "', multiShipping='" + multiShipping + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingContainer that = (ShippingContainer) o;
    return Objects.equals(shippingMode, that.shippingMode) &&
        Objects.equals(singleShipping, that.singleShipping) &&
        Objects.equals(multiShipping, that.multiShipping);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingMode, singleShipping, multiShipping);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ShippingMode shippingMode;

    private Shipping singleShipping;

    private List<Shipping> multiShipping;

    public ShippingContainer build() {
      ShippingContainer result = new ShippingContainer();
      result.shippingMode = this.shippingMode;
      result.singleShipping = this.singleShipping;
      result.multiShipping = this.multiShipping;
      return result;
    }

    public Builder shippingMode(ShippingMode shippingMode) {
      this.shippingMode = shippingMode;
      return this;
    }

    public Builder singleShipping(Shipping singleShipping) {
      this.singleShipping = singleShipping;
      return this;
    }

    public Builder multiShipping(List<Shipping> multiShipping) {
      this.multiShipping = multiShipping;
      return this;
    }
  }
}
