package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ShippingDraft {
  private String key;

  private ResourceIdentifierInput shippingMethod;

  private AddressInput shippingAddress;

  private ShippingRateInputDraft shippingRateInput;

  private ExternalTaxRateDraft externalTaxRate;

  private List<DeliveryDraft> deliveries;

  private CustomFieldsDraft custom;

  public ShippingDraft() {
  }

  public ShippingDraft(String key, ResourceIdentifierInput shippingMethod,
      AddressInput shippingAddress, ShippingRateInputDraft shippingRateInput,
      ExternalTaxRateDraft externalTaxRate, List<DeliveryDraft> deliveries,
      CustomFieldsDraft custom) {
    this.key = key;
    this.shippingMethod = shippingMethod;
    this.shippingAddress = shippingAddress;
    this.shippingRateInput = shippingRateInput;
    this.externalTaxRate = externalTaxRate;
    this.deliveries = deliveries;
    this.custom = custom;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public ResourceIdentifierInput getShippingMethod() {
    return shippingMethod;
  }

  public void setShippingMethod(ResourceIdentifierInput shippingMethod) {
    this.shippingMethod = shippingMethod;
  }

  public AddressInput getShippingAddress() {
    return shippingAddress;
  }

  public void setShippingAddress(AddressInput shippingAddress) {
    this.shippingAddress = shippingAddress;
  }

  public ShippingRateInputDraft getShippingRateInput() {
    return shippingRateInput;
  }

  public void setShippingRateInput(ShippingRateInputDraft shippingRateInput) {
    this.shippingRateInput = shippingRateInput;
  }

  public ExternalTaxRateDraft getExternalTaxRate() {
    return externalTaxRate;
  }

  public void setExternalTaxRate(ExternalTaxRateDraft externalTaxRate) {
    this.externalTaxRate = externalTaxRate;
  }

  public List<DeliveryDraft> getDeliveries() {
    return deliveries;
  }

  public void setDeliveries(List<DeliveryDraft> deliveries) {
    this.deliveries = deliveries;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "ShippingDraft{key='" + key + "', shippingMethod='" + shippingMethod + "', shippingAddress='" + shippingAddress + "', shippingRateInput='" + shippingRateInput + "', externalTaxRate='" + externalTaxRate + "', deliveries='" + deliveries + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingDraft that = (ShippingDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(shippingMethod, that.shippingMethod) &&
        Objects.equals(shippingAddress, that.shippingAddress) &&
        Objects.equals(shippingRateInput, that.shippingRateInput) &&
        Objects.equals(externalTaxRate, that.externalTaxRate) &&
        Objects.equals(deliveries, that.deliveries) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, shippingMethod, shippingAddress, shippingRateInput, externalTaxRate, deliveries, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private ResourceIdentifierInput shippingMethod;

    private AddressInput shippingAddress;

    private ShippingRateInputDraft shippingRateInput;

    private ExternalTaxRateDraft externalTaxRate;

    private List<DeliveryDraft> deliveries;

    private CustomFieldsDraft custom;

    public ShippingDraft build() {
      ShippingDraft result = new ShippingDraft();
      result.key = this.key;
      result.shippingMethod = this.shippingMethod;
      result.shippingAddress = this.shippingAddress;
      result.shippingRateInput = this.shippingRateInput;
      result.externalTaxRate = this.externalTaxRate;
      result.deliveries = this.deliveries;
      result.custom = this.custom;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder shippingMethod(ResourceIdentifierInput shippingMethod) {
      this.shippingMethod = shippingMethod;
      return this;
    }

    public Builder shippingAddress(AddressInput shippingAddress) {
      this.shippingAddress = shippingAddress;
      return this;
    }

    public Builder shippingRateInput(ShippingRateInputDraft shippingRateInput) {
      this.shippingRateInput = shippingRateInput;
      return this;
    }

    public Builder externalTaxRate(ExternalTaxRateDraft externalTaxRate) {
      this.externalTaxRate = externalTaxRate;
      return this;
    }

    public Builder deliveries(List<DeliveryDraft> deliveries) {
      this.deliveries = deliveries;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
