package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ShippingInfo {
  private String shippingMethodName;

  private Money price;

  private ShippingRate shippingRate;

  private TaxRate taxRate;

  private List<Delivery> deliveries;

  private DiscountedLineItemPrice discountedPrice;

  private ShippingMethodState shippingMethodState;

  private ShippingMethod shippingMethod;

  private Reference shippingMethodRef;

  private TaxCategory taxCategory;

  private Reference taxCategoryRef;

  private TaxedItemPrice taxedPrice;

  public ShippingInfo() {
  }

  public ShippingInfo(String shippingMethodName, Money price, ShippingRate shippingRate,
      TaxRate taxRate, List<Delivery> deliveries, DiscountedLineItemPrice discountedPrice,
      ShippingMethodState shippingMethodState, ShippingMethod shippingMethod,
      Reference shippingMethodRef, TaxCategory taxCategory, Reference taxCategoryRef,
      TaxedItemPrice taxedPrice) {
    this.shippingMethodName = shippingMethodName;
    this.price = price;
    this.shippingRate = shippingRate;
    this.taxRate = taxRate;
    this.deliveries = deliveries;
    this.discountedPrice = discountedPrice;
    this.shippingMethodState = shippingMethodState;
    this.shippingMethod = shippingMethod;
    this.shippingMethodRef = shippingMethodRef;
    this.taxCategory = taxCategory;
    this.taxCategoryRef = taxCategoryRef;
    this.taxedPrice = taxedPrice;
  }

  public String getShippingMethodName() {
    return shippingMethodName;
  }

  public void setShippingMethodName(String shippingMethodName) {
    this.shippingMethodName = shippingMethodName;
  }

  public Money getPrice() {
    return price;
  }

  public void setPrice(Money price) {
    this.price = price;
  }

  public ShippingRate getShippingRate() {
    return shippingRate;
  }

  public void setShippingRate(ShippingRate shippingRate) {
    this.shippingRate = shippingRate;
  }

  public TaxRate getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(TaxRate taxRate) {
    this.taxRate = taxRate;
  }

  public List<Delivery> getDeliveries() {
    return deliveries;
  }

  public void setDeliveries(List<Delivery> deliveries) {
    this.deliveries = deliveries;
  }

  public DiscountedLineItemPrice getDiscountedPrice() {
    return discountedPrice;
  }

  public void setDiscountedPrice(DiscountedLineItemPrice discountedPrice) {
    this.discountedPrice = discountedPrice;
  }

  public ShippingMethodState getShippingMethodState() {
    return shippingMethodState;
  }

  public void setShippingMethodState(ShippingMethodState shippingMethodState) {
    this.shippingMethodState = shippingMethodState;
  }

  public ShippingMethod getShippingMethod() {
    return shippingMethod;
  }

  public void setShippingMethod(ShippingMethod shippingMethod) {
    this.shippingMethod = shippingMethod;
  }

  public Reference getShippingMethodRef() {
    return shippingMethodRef;
  }

  public void setShippingMethodRef(Reference shippingMethodRef) {
    this.shippingMethodRef = shippingMethodRef;
  }

  public TaxCategory getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(TaxCategory taxCategory) {
    this.taxCategory = taxCategory;
  }

  public Reference getTaxCategoryRef() {
    return taxCategoryRef;
  }

  public void setTaxCategoryRef(Reference taxCategoryRef) {
    this.taxCategoryRef = taxCategoryRef;
  }

  public TaxedItemPrice getTaxedPrice() {
    return taxedPrice;
  }

  public void setTaxedPrice(TaxedItemPrice taxedPrice) {
    this.taxedPrice = taxedPrice;
  }

  @Override
  public String toString() {
    return "ShippingInfo{shippingMethodName='" + shippingMethodName + "', price='" + price + "', shippingRate='" + shippingRate + "', taxRate='" + taxRate + "', deliveries='" + deliveries + "', discountedPrice='" + discountedPrice + "', shippingMethodState='" + shippingMethodState + "', shippingMethod='" + shippingMethod + "', shippingMethodRef='" + shippingMethodRef + "', taxCategory='" + taxCategory + "', taxCategoryRef='" + taxCategoryRef + "', taxedPrice='" + taxedPrice + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingInfo that = (ShippingInfo) o;
    return Objects.equals(shippingMethodName, that.shippingMethodName) &&
        Objects.equals(price, that.price) &&
        Objects.equals(shippingRate, that.shippingRate) &&
        Objects.equals(taxRate, that.taxRate) &&
        Objects.equals(deliveries, that.deliveries) &&
        Objects.equals(discountedPrice, that.discountedPrice) &&
        Objects.equals(shippingMethodState, that.shippingMethodState) &&
        Objects.equals(shippingMethod, that.shippingMethod) &&
        Objects.equals(shippingMethodRef, that.shippingMethodRef) &&
        Objects.equals(taxCategory, that.taxCategory) &&
        Objects.equals(taxCategoryRef, that.taxCategoryRef) &&
        Objects.equals(taxedPrice, that.taxedPrice);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingMethodName, price, shippingRate, taxRate, deliveries, discountedPrice, shippingMethodState, shippingMethod, shippingMethodRef, taxCategory, taxCategoryRef, taxedPrice);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String shippingMethodName;

    private Money price;

    private ShippingRate shippingRate;

    private TaxRate taxRate;

    private List<Delivery> deliveries;

    private DiscountedLineItemPrice discountedPrice;

    private ShippingMethodState shippingMethodState;

    private ShippingMethod shippingMethod;

    private Reference shippingMethodRef;

    private TaxCategory taxCategory;

    private Reference taxCategoryRef;

    private TaxedItemPrice taxedPrice;

    public ShippingInfo build() {
      ShippingInfo result = new ShippingInfo();
      result.shippingMethodName = this.shippingMethodName;
      result.price = this.price;
      result.shippingRate = this.shippingRate;
      result.taxRate = this.taxRate;
      result.deliveries = this.deliveries;
      result.discountedPrice = this.discountedPrice;
      result.shippingMethodState = this.shippingMethodState;
      result.shippingMethod = this.shippingMethod;
      result.shippingMethodRef = this.shippingMethodRef;
      result.taxCategory = this.taxCategory;
      result.taxCategoryRef = this.taxCategoryRef;
      result.taxedPrice = this.taxedPrice;
      return result;
    }

    public Builder shippingMethodName(String shippingMethodName) {
      this.shippingMethodName = shippingMethodName;
      return this;
    }

    public Builder price(Money price) {
      this.price = price;
      return this;
    }

    public Builder shippingRate(ShippingRate shippingRate) {
      this.shippingRate = shippingRate;
      return this;
    }

    public Builder taxRate(TaxRate taxRate) {
      this.taxRate = taxRate;
      return this;
    }

    public Builder deliveries(List<Delivery> deliveries) {
      this.deliveries = deliveries;
      return this;
    }

    public Builder discountedPrice(DiscountedLineItemPrice discountedPrice) {
      this.discountedPrice = discountedPrice;
      return this;
    }

    public Builder shippingMethodState(ShippingMethodState shippingMethodState) {
      this.shippingMethodState = shippingMethodState;
      return this;
    }

    public Builder shippingMethod(ShippingMethod shippingMethod) {
      this.shippingMethod = shippingMethod;
      return this;
    }

    public Builder shippingMethodRef(Reference shippingMethodRef) {
      this.shippingMethodRef = shippingMethodRef;
      return this;
    }

    public Builder taxCategory(TaxCategory taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }

    public Builder taxCategoryRef(Reference taxCategoryRef) {
      this.taxCategoryRef = taxCategoryRef;
      return this;
    }

    public Builder taxedPrice(TaxedItemPrice taxedPrice) {
      this.taxedPrice = taxedPrice;
      return this;
    }
  }
}
